function init() {
	var scene = new THREE.Scene();

	var box = getBox(1, 1, 1);
	var plane = getPlane(4);

	plane.name = 'plane-1';

	box.position.y = box.geometry.parameters.height/2;
	box.position.z = -box.geometry.parameters.height/2;
	plane.rotation.x = Math.PI/2;
	plane.position.y = 1;

	plane.add(box);
	scene.add(plane);

	///////////////////1/////////////
	// var gui = new dat.GUI();
	// gui.add(box.scale, 'x', 0, 5);
	// gui.add(box.scale, 'y', 0, 5);
	//////////////////////////////////

	var camera = new THREE.PerspectiveCamera(
		45,
		window.innerWidth/window.innerHeight,
		1,
		1000
	);

	camera.position.x = 1;
	camera.position.y = 2;
	camera.position.z = 5;

	camera.lookAt(new THREE.Vector3(0, 0, 0));

	var renderer = new THREE.WebGLRenderer();
	renderer.setSize(window.innerWidth, window.innerHeight);
	document.getElementById('webgl').appendChild(renderer.domElement);

	///////////////////2/////////////
	//var controls = new THREE.OrbitControls(camera, renderer.domElement);
	//update(renderer, scene, camera, controls);
	update(renderer, scene, camera);
	/////////////////////////////////////

	return scene;
}

function getBox(w, h, d) {
	var geometry = new THREE.BoxGeometry(w, h, d);
	var material = new THREE.MeshBasicMaterial({
		color: 0x00ff00
	});
	var mesh = new THREE.Mesh(
		geometry,
		material 
	);

	return mesh;
}

function getPlane(size) {
	var geometry = new THREE.PlaneGeometry(size, size);
	var material = new THREE.MeshBasicMaterial({
		color: 0xff0000,
		side: THREE.DoubleSide
	});
	var mesh = new THREE.Mesh(
		geometry,
		material 
	);

	return mesh;
}

function update(renderer, scene, camera) {
	renderer.render(
		scene,
		camera
	);
	
	var plane = scene.getObjectByName('plane-1');
	plane.rotation.y += 0.001;
	plane.rotation.z += 0.001;


	requestAnimationFrame(function() {
		update(renderer, scene, camera);
	})
}


////////////////////////////2//////////////////////////////
// function update(renderer, scene, camera, controls) {
// 	renderer.render(
// 		scene,
// 		camera
// 	);

// 	var plane = scene.getObjectByName('plane-1');
// 	plane.rotation.y += 0.001;
// 	plane.rotation.z += 0.001;

// 		requestAnimationFrame(function() {
// 		update(renderer, scene, camera, controls);
// 	})
// }
////////////////////////////////////////////////

var scene = init();