# UR10 Integration

## To run the code with UR10
1. Clone repo
   - `git clone ssh://git@gitlab.cba.mit.edu:846/amiraa/physical-computing-design-tools.git`
2. install node.js and npm
   - https://nodejs.org/en/download/
3. Navigate to `./physical-computing-design-tools/01_Code/physical_computing_interface/setup`
   -  `cd physical-computing-design-tools/01_Code/physical_computing_interface/setup`
4. run this command to install all node.js dependencies
   - `npm install`
   - the dependencies are `express`, `edit-json-file`, `child_process` (you can install them independently using `npm install name` if the first command doesn't work)
5. Now you can run the node.js server by running
   - `node server.js` 
6. this will show you instructions to navigate to `http://localhost:8080/demos/indexUR10.html` on your browser
7. There you can **first** change the settings in the json editor in the bottom right, these are under ur10Setup parameters settings:
   -  ![](./json.png)
    ```javascript
    {
        run:true, // if true it will call the python script to move the UR10s, if false it will just save the setup ../assembly/python-urx/setup.json
        pythonFileName: "ur10test", //in ./assembly/python-urx/
        ipNode: "192.168.1.52", //ip address 
        ipEdge: "192.168.1.53",
        latticePitch:{
            x:0.031,
            y:0.031,
            z:0.006,
        },
        nodePickupRobotHome:{
            x: -1.5394771734820765,
            y: -1.6685369650470179,
            z: -2.495819155369894,
            rx:-2.1159094015704554,
            ry:-1.5422142187701624,
            rz:-1.5874159971820276,
        },
        edgePickupRobotHome:{
            x: -0.21965343156923467,
            y: -1.5261443297015589,
            z: 2.5553131103515625,
            rx:-1.0277064482318323,
            ry:1.3498035669326782,
            rz:-1.5769990126239222,
        },
        programmingRelativeDistance:{
            x: -0.203,
            y: 0.0127,
            z: 0.013,
            rx:0,
            ry:0,
            rz:0,
        },
        nodeRelativeDistance:{
            x: -0.4417,
            y: 0.005,
            z: 0.04,
            rx:0,
            ry:0,
            rz:0
        },
        edgeRelativeDistance:{
            x: 0,
            y: 0,
            z: 0.04,
            rx:0,
            ry:0,
            rz:0
        },
        v:0.5, //velocity to go to home
        a:0.5, //acceleration to go to home
        v1:0.05, //velocity to go to node/edge
        a1:0.05, //velocity to go to node/edge
        sleep:0.2,
        sleep1:0.1,
    },
    ```
8. If the settings are correct you can place the nodes in the assembly 3d grid, for now place them in the bottom right corner
   - ![](./nodes.png)
9.  You can run after placing one node or after placing both nodes by pressing right click while the cursor is on the node; then the radial menu will appear, you can then press play.
   - ![](./run.png)
11. This will save the current setup to `./physical-computing-design-tools/01_Code/physical_computing_interface/assembly/python-urx/setup.json` and if `run:true` it will run the python file that is in `./physical-computing-design-tools/01_Code/physical_computing_interface/assembly/python-urx/` for example `ur10test.py`
12. `./physical-computing-design-tools/01_Code/physical_computing_interface/assembly/python-urx/ur10test.py` uses `python-urx` library to communicate with the UR10s and it uses the settings in `./physical-computing-design-tools/01_Code/physical_computing_interface/assembly/python-urx/setup.json`, you can debug this independently.