# Digital Material Modeling and Simulation

Case study of the design and optimization of Macro-DICE.

Hardware Implementation:
- [VoxRob](https://gitlab.cba.mit.edu/bej/voxrob)
- [rover](https://gitlab.cba.mit.edu/ccameron/rover)
- [DM3](https://gitlab.cba.mit.edu/bej/dm3)


## Structure Simulation Integration

Using the [MetaVoxel simulation tool](https://gitlab.cba.mit.edu/amiraa/metavoxels):

<img src="./200114_simulation.PNG" width="80%" /><br/>

## Robotics Design

<img src="./dice_assembly.gif" width="80%" /><br/>

## Assembly
- Option for different kinds of assembly (swarm assembly)
  
<img src="./assembly.gif" width="80%" /> <br/>

## Control

- [Check Control Function Graph](https://amiraa.pages.cba.mit.edu/physical-computing-design-tools/01_Code/physical_computing_interface/graph/control/control.html)
  
<img src="./1rover4.gif" width="40%" />
<img src="./1rover2.gif" width="40%" /><br/>
<img src="./1rover1.gif" width="40%" />
<img src="./1rover3.gif" width="40%" />


## Optimization

- Two level optimization
  - Shape (body) => [Hierarchal Local Online Shape Optimization](https://gitlab.cba.mit.edu/amiraa/metavoxels/-/blob/master/02_Presentation/top_opt/search.md)
  - Control (mind) => [AI that grows](../AI_that_grows/AI_grow.md)
  - Simultaneous optimization of shape and control

