#
# mpipi.py
# Neil Gershenfeld 2/6/20
# calculation of pi by an MPI Numba sum
# pi = 3.14159265358979323846 
#

import time
from numba import jit
from mpi4py import MPI

@jit(nopython=True)
def calc(istart,iend):
   sum = 0.0
   for i in range(istart,iend+1):
      sum += 0.5/((i-0.75)*(i-0.25))
   return sum

NPTS = 100000000000
comm = MPI.COMM_WORLD
rank = comm.Get_rank()
nproc = comm.Get_size()
if (rank == 0):
   start_time = time.time()
   istart = int(1 + NPTS*((rank+0)/nproc))
   iend = int(NPTS*((rank+1)/nproc))
   pi = calc(istart,iend)
   comm.reduce(pi,op=MPI.SUM,root=0)
   end_time = time.time()
   mflops = NPTS*5.0/(1.0e6*(end_time-start_time))
   print("NPTS = %d, pi = %f"%(NPTS,pi))
   print("time = %f, estimated MFlops = %f"%(end_time-start_time,mflops))
else:
   istart = int(1 + NPTS*((rank+0)/nproc))
   iend = int(NPTS*((rank+1)/nproc))
   pi = calc(istart,iend)
   comm.reduce(pi,op=MPI.SUM,root=0)
